<?php
/**
 * @package     HSDraw!
 * @author      Hosting Skills a.s.b.l. - http://www.hosting-skills.lu
 * @copyright   Copyright (C) 2014-2024 Hosting Skills a.s.b.l.. All rights reserved.
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

// No direct access
defined('JPATH_PLATFORM') or die;

/**
 * HSDraw! Language Installer Script.
 */
class HSDraw_es_esInstallerScript {
	/**
	 * Database Connector Object
	 *
	 * @var  JDatabaseDriver
	 */
	protected $db;

	/**
	 * Runs just before any installation action is preformed on the component.
	 * Verifications and pre-requisites should run in this function.
	 *
	 * @param  string                    $type    Type of PreFlight action. Possible values are:
	 *                                            * install
	 *                                            * update
	 *                                            * discover_install
	 * @param  JInstallerAdapterPackage  $parent  Parent object calling object.
	 *
	 * @return  boolean
	 */
    public function preflight($type, $parent) {
        $version        = new JVersion();
        $new_version    = $parent->get('manifest')->version;
        $joomla_version = $parent->get('manifest')->attributes()->version;

	    $this->db = $parent->getParent()->getDbo();

	    if ($this->isPackageNotInstalled()) {
		    JLog::add(JText::_('FILES_HSDRAW_ES_ES_HSDRAW_MISSING'), JLog::WARNING, 'jerror');
		    return false;
	    }

	    if (version_compare($version->getShortVersion(), $joomla_version, 'lt')) {
		    JLog::add(JText::sprintf('FILES_HSDRAW_ES_ES_JOOMLA_VERSION_ERROR', JText::_('FILES_HSDRAW_ES_ES'), $joomla_version), JLog::WARNING, 'jerror');
		    return false;
	    }

	    if ('update' == $type) {
		    $old_version = $this->getVersion($parent->get('manifest')->name, $new_version);

		    if (version_compare($new_version, $old_version, 'le')) {
			    JLog::add(JText::sprintf('FILES_HSDRAW_ES_ES_UPDATE_VERSION_ERROR', JText::_('FILES_HSDRAW_ES_ES'), $old_version, $new_version), JLog::WARNING, 'jerror');
			    return false;
		    }
	    }

		$pkg_version = $this->getVersion('pkg_hsdraw', '<i>unknown</i>');

	    $parent->getParent()->message = '<h2>'.JText::_('FILES_HSDRAW_ES_ES_HSDRAW_TITLE').'</h2>';
	    $parent->getParent()->message .= JText::sprintf('FILES_HSDRAW_ES_ES_LANGUAGE', $pkg_version);
	    $parent->getParent()->message .= '<br /><br /><ul>';
    }

	/**
	 * This method is called after a component is installed.
	 *
	 * @param  JInstallerAdapterPackage  $parent  Parent object calling this method.
	 *
	 * @return  boolean
	 */
	public function install($parent) {
		$parent->getParent()->message .= '<li>' . JText::_('FILES_HSDRAW_ES_ES') . ' <span style="color: green;">' . JText::sprintf('FILES_HSDRAW_ES_ES_LANGUAGE_INSTALL', $parent->get('manifest')->version) . '</span></li>';

		return true;
	}

	/**
	 * This method is called after a component is updated.
	 *
	 * @param  JInstallerAdapterPackage  $parent  Parent object calling object.
	 *
	 * @return  boolean
	 */
	public function update($parent) {
		$parent->getParent()->message .= '<li>' . JText::_('FILES_HSDRAW_ES_ES') . ' <span style="color: green;">' . JText::sprintf('FILES_HSDRAW_ES_ES_LANGUAGE_UPDATE', $parent->get('manifest')->version) . '</span></li>';

		return true;
	}

	/**
	 * This method is called after a component is uninstalled.
	 *
	 * @param  JInstallerAdapterPackage  $parent  Parent object calling this method.
	 *
	 * @return  boolean
	 */
	public function uninstall($parent) {
		return true;
	}

	/**
	 * Runs right after any installation action is preformed on the component.
	 *
	 * @param  string                      $type    Type of PostFlight action. Possible values are:
	 *                                              * install
	 *                                              * update
	 *                                              * discover_install
	 * @param  JInstallerAdapterComponent  $parent  Parent object calling object.
	 *
	 * @return  boolean
	 */
	public function postflight($type, $parent) {
		$parent->getParent()->message .= '</ul><br /><img src="../media/com_hsdraw/images/hsdraw.png" alt="HSDraw!" /><br /><br />';
    }

	/**
	 * Get the version of the extension.
	 *
	 * @param  string  $name     The name of the extension.
	 * @param  string  $default  The default version to use if the extension does not exist.
	 *
	 * @return  string  The version of the extension.
	 */
	protected function getVersion($name, $default = null) {
		$query = $this->db->getQuery(true);
		$query->select($this->db->quoteName('manifest_cache'))
			->from($this->db->quoteName('#__extensions'))
			->where($this->db->quoteName('name') . ' = ' . $this->db->quote($name));
		$this->db->setQuery($query);
		$this->db->execute();
		if (0 == $this->db->getNumRows()) {
			return $default;
		}
		$manifest = json_decode($this->db->loadResult(), true);

		return $manifest['version'];
	}

	/**
	 * Check if package is installed.
	 *
	 * @param  string  $name  The name of the package.
	 *
	 * @return  boolean
	 */
	protected function isPackageNotInstalled($name = 'pkg_hsdraw') {
		$query = $this->db->getQuery(true);
		$query->select($this->db->quoteName('extension_id'))
			->from($this->db->quoteName('#__extensions'))
			->where($this->db->quoteName('name') . ' = ' . $this->db->quote($name));
		$this->db->setQuery($query);
		$this->db->execute();

		return 0 == $this->db->getNumRows();
	}
}